package org.kodein.emoji.smileys_emotion.face_concerned

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ConfoundedFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😖",
        description = "confounded face",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("confounded-face", "scrunched-mouth", "confounded", "zigzag-mouth"),
        emoticons = listOf(">:["),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-concerned: confounded face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ConfoundedFace: Emoji get() = _ConfoundedFace

/**
 * Alias to emoji [ConfoundedFace] (Smileys & Emotion: face-concerned: confounded face).
*/
public val Emoji.Companion.ScrunchedMouth: Emoji get() = _ConfoundedFace

/**
 * Alias to emoji [ConfoundedFace] (Smileys & Emotion: face-concerned: confounded face).
*/
public val Emoji.Companion.Confounded: Emoji get() = _ConfoundedFace

/**
 * Alias to emoji [ConfoundedFace] (Smileys & Emotion: face-concerned: confounded face).
*/
public val Emoji.Companion.ZigzagMouth: Emoji get() = _ConfoundedFace
