package org.kodein.emoji.smileys_emotion.face_smiling

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _GrinningFaceWithSweat: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😅",
        description = "grinning face with sweat",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("grinning-face-with-sweat", "grin-sweat"),
        emoticons = listOf("^_^;"),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-smiling: grinning face with sweat.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.GrinningFaceWithSweat: Emoji get() = _GrinningFaceWithSweat

/**
 * Alias to emoji [GrinningFaceWithSweat] (Smileys & Emotion: face-smiling: grinning face with sweat).
*/
public val Emoji.Companion.GrinSweat: Emoji get() = _GrinningFaceWithSweat
