package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _InputLatinLowercase: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔡",
        description = "input latin lowercase",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("input-latin-lowercase", "lowercase-letters"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: alphanum: input latin lowercase.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.InputLatinLowercase: Emoji get() = _InputLatinLowercase

/**
 * Alias to emoji [InputLatinLowercase] (Symbols: alphanum: input latin lowercase).
*/
public val Emoji.Companion.LowercaseLetters: Emoji get() = _InputLatinLowercase
