package org.kodein.emoji.symbols.other_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _JapaneseSymbolForBeginner: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔰",
        description = "Japanese symbol for beginner",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("japanese-symbol-for-beginner", "beginner"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: other-symbol: Japanese symbol for beginner.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.JapaneseSymbolForBeginner: Emoji get() = _JapaneseSymbolForBeginner

/**
 * Alias to emoji [JapaneseSymbolForBeginner] (Symbols: other-symbol: Japanese symbol for beginner).
*/
public val Emoji.Companion.Beginner: Emoji get() = _JapaneseSymbolForBeginner
