package org.kodein.emoji.travel_places.sky_weather

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SunBehindRainCloud: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🌦️",
        description = "sun behind rain cloud",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("sun-behind-rain-cloud", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Travel & Places: sky & weather: sun behind rain cloud.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SunBehindRainCloud: Emoji get() = _SunBehindRainCloud
