package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagAntarctica: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇦🇶",
        description = "flag: Antarctica",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-antarctica", "antarctica-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Antarctica.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagAntarctica: Emoji get() = _FlagAntarctica

/**
 * Alias to emoji [FlagAntarctica] (Flags: country-flag: flag: Antarctica).
*/
public val Emoji.Companion.AntarcticaFlag: Emoji get() = _FlagAntarctica
