package org.kodein.emoji.smileys_emotion.face_costume

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PileOfPoo: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💩",
        description = "pile of poo",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("pile-of-poo", "poop"),
        emoticons = listOf("༼^-^༽"),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-costume: pile of poo.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PileOfPoo: Emoji get() = _PileOfPoo

/**
 * Alias to emoji [PileOfPoo] (Smileys & Emotion: face-costume: pile of poo).
*/
public val Emoji.Companion.Poop: Emoji get() = _PileOfPoo
