package org.kodein.emoji.travel_places.hotel

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllHotel() {
    add(intArrayOf(0x1f9f3), _Luggage)
    add(intArrayOf(0x1f6ce, 0xfe0f), _BellhopBell)
    add(intArrayOf(0x1f6ce), _BellhopBell)
}

internal fun MutableList<Emoji>.addAllHotel() {
    add(_Luggage)
    add(_BellhopBell)
}

/**
 * All Emoji of the Travel & Places: hotel subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allHotel(): List<Emoji> =
    ArrayList<Emoji>(2).apply { addAllHotel() }
