package org.kodein.emoji

import org.kodein.emoji.animals_nature.*
import org.kodein.emoji.food_drink.*
import org.kodein.emoji.activities.*
import org.kodein.emoji.objects.*
import org.kodein.emoji.travel_places.*
import org.kodein.emoji.flags.*
import org.kodein.emoji.people_body.*
import org.kodein.emoji.smileys_emotion.*
import org.kodein.emoji.symbols.*


internal fun EmojiFinder.addAllEmoji() {
    addAllAnimalsNature()
    addAllFoodDrink()
    addAllActivities()
    addAllObjects()
    addAllTravelPlaces()
    addAllFlags()
    addAllPeopleBody()
    addAllSmileysEmotion()
    addAllSymbols()
}

internal val emojiCount get() = 1898
internal val emojiAliasCount get() = 2721
internal val emojiEmoticonCount get() = 112

/**
 * All known Emoji.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.all(): List<Emoji> =
    ArrayList<Emoji>(emojiCount).apply {
        addAllAnimalsNature()
        addAllFoodDrink()
        addAllActivities()
        addAllObjects()
        addAllTravelPlaces()
        addAllFlags()
        addAllPeopleBody()
        addAllSmileysEmotion()
        addAllSymbols()
    }

internal fun allEmojiGroups(): Map<String, Map<String, () -> List<Emoji>>> =
    mapOf(
        "animals_nature" to allAnimalsNatureSubgroups(),
        "food_drink" to allFoodDrinkSubgroups(),
        "activities" to allActivitiesSubgroups(),
        "objects" to allObjectsSubgroups(),
        "travel_places" to allTravelPlacesSubgroups(),
        "flags" to allFlagsSubgroups(),
        "people_body" to allPeopleBodySubgroups(),
        "smileys_emotion" to allSmileysEmotionSubgroups(),
        "symbols" to allSymbolsSubgroups(),
    )
