package org.kodein.emoji.activities.sport

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PingPong: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🏓",
        description = "ping pong",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("ping-pong", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Activities: sport: ping pong.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PingPong: Emoji get() = _PingPong
