package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagIndia: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇮🇳",
        description = "flag: India",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-india", "india-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: India.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagIndia: Emoji get() = _FlagIndia

/**
 * Alias to emoji [FlagIndia] (Flags: country-flag: flag: India).
*/
public val Emoji.Companion.IndiaFlag: Emoji get() = _FlagIndia
