package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagNauru: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇳🇷",
        description = "flag: Nauru",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-nauru", "nauru-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Nauru.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagNauru: Emoji get() = _FlagNauru

/**
 * Alias to emoji [FlagNauru] (Flags: country-flag: flag: Nauru).
*/
public val Emoji.Companion.NauruFlag: Emoji get() = _FlagNauru
