package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagStKittsNevis: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇰🇳",
        description = "flag: St. Kitts & Nevis",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-st-kitts-nevis", "st-kitts-nevis-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: St. Kitts & Nevis.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagStKittsNevis: Emoji get() = _FlagStKittsNevis

/**
 * Alias to emoji [FlagStKittsNevis] (Flags: country-flag: flag: St. Kitts & Nevis).
*/
public val Emoji.Companion.StKittsNevisFlag: Emoji get() = _FlagStKittsNevis
