package org.kodein.emoji.people_body.person_activity

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonClimbing: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🧗",
        description = "person climbing",
        unicodeVersion = UnicodeVersion(5, 0),
        aliases = listOf("person-climbing", "climbing"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-activity: person climbing.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonClimbing: SkinTone1Emoji get() = _PersonClimbing

/**
 * Alias to emoji [PersonClimbing] (People & Body: person-activity: person climbing).
*/
public val Emoji.Companion.Climbing: SkinTone1Emoji get() = _PersonClimbing
