package org.kodein.emoji.smileys_emotion.cat_face

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _GrinningCat: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😺",
        description = "grinning cat",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("grinning-cat", "smiley-cat"),
        emoticons = listOf(":3"),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: cat-face: grinning cat.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.GrinningCat: Emoji get() = _GrinningCat

/**
 * Alias to emoji [GrinningCat] (Smileys & Emotion: cat-face: grinning cat).
*/
public val Emoji.Companion.SmileyCat: Emoji get() = _GrinningCat
