package org.kodein.emoji.smileys_emotion.face_concerned

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PerseveringFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😣",
        description = "persevering face",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("persevering-face", "scrunched-eyes", "persevering"),
        emoticons = listOf(">:("),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-concerned: persevering face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PerseveringFace: Emoji get() = _PerseveringFace

/**
 * Alias to emoji [PerseveringFace] (Smileys & Emotion: face-concerned: persevering face).
*/
public val Emoji.Companion.ScrunchedEyes: Emoji get() = _PerseveringFace

/**
 * Alias to emoji [PerseveringFace] (Smileys & Emotion: face-concerned: persevering face).
*/
public val Emoji.Companion.Persevering: Emoji get() = _PerseveringFace
