package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WhiteMediumSmallSquare: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "◽",
        description = "white medium-small square",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("white-medium-small-square", "white-square-medium-small"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: geometric: white medium-small square.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WhiteMediumSmallSquare: Emoji get() = _WhiteMediumSmallSquare

/**
 * Alias to emoji [WhiteMediumSmallSquare] (Symbols: geometric: white medium-small square).
*/
public val Emoji.Companion.WhiteSquareMediumSmall: Emoji get() = _WhiteMediumSmallSquare
