package org.kodein.emoji.symbols.math

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _HeavyEqualsSign: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🟰",
        description = "heavy equals sign",
        unicodeVersion = UnicodeVersion(14, 0),
        aliases = listOf("heavy-equals-sign", "equals-sign", "-"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: math: heavy equals sign.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.HeavyEqualsSign: Emoji get() = _HeavyEqualsSign

/**
 * Alias to emoji [HeavyEqualsSign] (Symbols: math: heavy equals sign).
*/
public val Emoji.Companion.EqualsSign: Emoji get() = _HeavyEqualsSign
