package org.kodein.emoji.symbols.other_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PartAlternationMark: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "〽️",
        description = "part alternation mark",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("part-alternation-mark", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: other-symbol: part alternation mark.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PartAlternationMark: Emoji get() = _PartAlternationMark
