package org.kodein.emoji.symbols.transport_sign

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PotableWater: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🚰",
        description = "potable water",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("potable-water", "water-faucet"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: transport-sign: potable water.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PotableWater: Emoji get() = _PotableWater

/**
 * Alias to emoji [PotableWater] (Symbols: transport-sign: potable water).
*/
public val Emoji.Companion.WaterFaucet: Emoji get() = _PotableWater
