package org.kodein.emoji.travel_places.time

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _TenOclock: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🕙",
        description = "ten o’clock",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("ten-oclock", "ten-o-clock"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Travel & Places: time: ten o’clock.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.TenOclock: Emoji get() = _TenOclock

/**
 * Alias to emoji [TenOclock] (Travel & Places: time: ten o’clock).
*/
public val Emoji.Companion.TenOClock: Emoji get() = _TenOclock
