package org.kodein.emoji.animals_nature.animal_bird

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllAnimalBird() {
    add(intArrayOf(0x1fabd), _Wing)
    add(intArrayOf(0x1fab6), _Feather)
    add(intArrayOf(0x1f426), _Bird)
    add(intArrayOf(0x1f426, 0x200d, 0x2b1b), _BlackBird)
    add(intArrayOf(0x1f413), _Rooster)
    add(intArrayOf(0x1f414), _Chicken)
    add(intArrayOf(0x1f423), _HatchingChick)
    add(intArrayOf(0x1f424), _BabyChick)
    add(intArrayOf(0x1f425), _FrontFacingBabyChick)
    add(intArrayOf(0x1f985), _Eagle)
    add(intArrayOf(0x1f989), _Owl)
    add(intArrayOf(0x1f99c), _Parrot)
    add(intArrayOf(0x1f54a, 0xfe0f), _Dove)
    add(intArrayOf(0x1f54a), _Dove)
    add(intArrayOf(0x1f9a4), _Dodo)
    add(intArrayOf(0x1f9a2), _Swan)
    add(intArrayOf(0x1f986), _Duck)
    add(intArrayOf(0x1fabf), _Goose)
    add(intArrayOf(0x1f9a9), _Flamingo)
    add(intArrayOf(0x1f99a), _Peacock)
    add(intArrayOf(0x1f983), _Turkey)
    add(intArrayOf(0x1f427), _Penguin)
    add(intArrayOf(0x1f426, 0x200d, 0x1f525), _Phoenix)
}

internal fun MutableList<Emoji>.addAllAnimalBird() {
    add(_Wing)
    add(_Feather)
    add(_Bird)
    add(_BlackBird)
    add(_Rooster)
    add(_Chicken)
    add(_HatchingChick)
    add(_BabyChick)
    add(_FrontFacingBabyChick)
    add(_Eagle)
    add(_Owl)
    add(_Parrot)
    add(_Dove)
    add(_Dodo)
    add(_Swan)
    add(_Duck)
    add(_Goose)
    add(_Flamingo)
    add(_Peacock)
    add(_Turkey)
    add(_Penguin)
    add(_Phoenix)
}

/**
 * All Emoji of the Animals & Nature: animal-bird subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allAnimalBird(): List<Emoji> =
    ArrayList<Emoji>(22).apply { addAllAnimalBird() }
