package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagFaroeIslands: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇫🇴",
        description = "flag: Faroe Islands",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-faroe-islands", "faroe-islands-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Faroe Islands.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagFaroeIslands: Emoji get() = _FlagFaroeIslands

/**
 * Alias to emoji [FlagFaroeIslands] (Flags: country-flag: flag: Faroe Islands).
*/
public val Emoji.Companion.FaroeIslandsFlag: Emoji get() = _FlagFaroeIslands
