package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagFiji: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇫🇯",
        description = "flag: Fiji",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-fiji", "fiji-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Fiji.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagFiji: Emoji get() = _FlagFiji

/**
 * Alias to emoji [FlagFiji] (Flags: country-flag: flag: Fiji).
*/
public val Emoji.Companion.FijiFlag: Emoji get() = _FlagFiji
