package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagMontserrat: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇲🇸",
        description = "flag: Montserrat",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-montserrat", "montserrat-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Montserrat.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagMontserrat: Emoji get() = _FlagMontserrat

/**
 * Alias to emoji [FlagMontserrat] (Flags: country-flag: flag: Montserrat).
*/
public val Emoji.Companion.MontserratFlag: Emoji get() = _FlagMontserrat
