package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagPoland: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇵🇱",
        description = "flag: Poland",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-poland", "poland-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Poland.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagPoland: Emoji get() = _FlagPoland

/**
 * Alias to emoji [FlagPoland] (Flags: country-flag: flag: Poland).
*/
public val Emoji.Companion.PolandFlag: Emoji get() = _FlagPoland
