package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagSouthSudan: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇸🇸",
        description = "flag: South Sudan",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-south-sudan", "south-sudan-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: South Sudan.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagSouthSudan: Emoji get() = _FlagSouthSudan

/**
 * Alias to emoji [FlagSouthSudan] (Flags: country-flag: flag: South Sudan).
*/
public val Emoji.Companion.SouthSudanFlag: Emoji get() = _FlagSouthSudan
