package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagVenezuela: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇻🇪",
        description = "flag: Venezuela",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-venezuela", "venezuela-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Venezuela.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagVenezuela: Emoji get() = _FlagVenezuela

/**
 * Alias to emoji [FlagVenezuela] (Flags: country-flag: flag: Venezuela).
*/
public val Emoji.Companion.VenezuelaFlag: Emoji get() = _FlagVenezuela
