package org.kodein.emoji.objects.computer

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FloppyDisk: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💾",
        description = "floppy disk",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("floppy-disk", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: computer: floppy disk.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FloppyDisk: Emoji get() = _FloppyDisk
