package org.kodein.emoji.objects.household

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllHousehold() {
    add(intArrayOf(0x1fae7), _Bubbles)
    add(intArrayOf(0x1f6d2), _ShoppingCart)
    add(intArrayOf(0x1fa9f), _Window)
    add(intArrayOf(0x1fa9e), _Mirror)
    add(intArrayOf(0x1f6aa), _Door)
    add(intArrayOf(0x1fa91), _Chair)
    add(intArrayOf(0x1f6cf, 0xfe0f), _Bed)
    add(intArrayOf(0x1f6cf), _Bed)
    add(intArrayOf(0x1f6cb, 0xfe0f), _CouchAndLamp)
    add(intArrayOf(0x1f6cb), _CouchAndLamp)
    add(intArrayOf(0x1f6bf), _Shower)
    add(intArrayOf(0x1f6c1), _Bathtub)
    add(intArrayOf(0x1f6bd), _Toilet)
    add(intArrayOf(0x1f9fb), _RollOfPaper)
    add(intArrayOf(0x1faa0), _Plunger)
    add(intArrayOf(0x1f9f7), _SafetyPin)
    add(intArrayOf(0x1f9f9), _Broom)
    add(intArrayOf(0x1f9f4), _LotionBottle)
    add(intArrayOf(0x1f9fd), _Sponge)
    add(intArrayOf(0x1f9fc), _Soap)
    add(intArrayOf(0x1faa5), _Toothbrush)
    add(intArrayOf(0x1fa92), _Razor)
    add(intArrayOf(0x1f9fa), _Basket)
    add(intArrayOf(0x1f9ef), _FireExtinguisher)
    add(intArrayOf(0x1faa3), _Bucket)
    add(intArrayOf(0x1faa4), _MouseTrap)
    add(intArrayOf(0x1f6d7), _Elevator)
}

internal fun MutableList<Emoji>.addAllHousehold() {
    add(_Bubbles)
    add(_ShoppingCart)
    add(_Window)
    add(_Mirror)
    add(_Door)
    add(_Chair)
    add(_Bed)
    add(_CouchAndLamp)
    add(_Shower)
    add(_Bathtub)
    add(_Toilet)
    add(_RollOfPaper)
    add(_Plunger)
    add(_SafetyPin)
    add(_Broom)
    add(_LotionBottle)
    add(_Sponge)
    add(_Soap)
    add(_Toothbrush)
    add(_Razor)
    add(_Basket)
    add(_FireExtinguisher)
    add(_Bucket)
    add(_MouseTrap)
    add(_Elevator)
}

/**
 * All Emoji of the Objects: household subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allHousehold(): List<Emoji> =
    ArrayList<Emoji>(25).apply { addAllHousehold() }
