package org.kodein.emoji.objects.light_video

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _RedPaperLantern: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🏮",
        description = "red paper lantern",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("red-paper-lantern", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: light & video: red paper lantern.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.RedPaperLantern: Emoji get() = _RedPaperLantern
