package org.kodein.emoji.objects.medical

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _DropOfBlood: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🩸",
        description = "drop of blood",
        unicodeVersion = UnicodeVersion(12, 0),
        aliases = listOf("drop-of-blood", "blood"),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Objects: medical: drop of blood.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.DropOfBlood: Emoji get() = _DropOfBlood

/**
 * Alias to emoji [DropOfBlood] (Objects: medical: drop of blood).
*/
public val Emoji.Companion.Blood: Emoji get() = _DropOfBlood
