package org.kodein.emoji.people_body.hand_fingers_open

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _LeftwardsPushingHand: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🫷",
        description = "leftwards pushing hand",
        unicodeVersion = UnicodeVersion(15, 0),
        aliases = listOf("leftwards-pushing-hand", "push-leftwards"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: hand-fingers-open: leftwards pushing hand.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.LeftwardsPushingHand: SkinTone1Emoji get() = _LeftwardsPushingHand

/**
 * Alias to emoji [LeftwardsPushingHand] (People & Body: hand-fingers-open: leftwards pushing hand).
*/
public val Emoji.Companion.PushLeftwards: SkinTone1Emoji get() = _LeftwardsPushingHand
