package org.kodein.emoji.people_body.hand_fingers_open

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _VulcanSalute: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🖖",
        description = "vulcan salute",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("vulcan-salute", "vulcan", "prosper", "spock"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: hand-fingers-open: vulcan salute.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.VulcanSalute: SkinTone1Emoji get() = _VulcanSalute

/**
 * Alias to emoji [VulcanSalute] (People & Body: hand-fingers-open: vulcan salute).
*/
public val Emoji.Companion.Vulcan: SkinTone1Emoji get() = _VulcanSalute

/**
 * Alias to emoji [VulcanSalute] (People & Body: hand-fingers-open: vulcan salute).
*/
public val Emoji.Companion.Prosper: SkinTone1Emoji get() = _VulcanSalute

/**
 * Alias to emoji [VulcanSalute] (People & Body: hand-fingers-open: vulcan salute).
*/
public val Emoji.Companion.Spock: SkinTone1Emoji get() = _VulcanSalute
