package org.kodein.emoji.smileys_emotion

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.smileys_emotion.face_affection.*
import org.kodein.emoji.smileys_emotion.face_sleepy.*
import org.kodein.emoji.smileys_emotion.cat_face.*
import org.kodein.emoji.smileys_emotion.face_negative.*
import org.kodein.emoji.smileys_emotion.heart.*
import org.kodein.emoji.smileys_emotion.face_smiling.*
import org.kodein.emoji.smileys_emotion.face_concerned.*
import org.kodein.emoji.smileys_emotion.emotion.*
import org.kodein.emoji.smileys_emotion.face_neutral_skeptical.*
import org.kodein.emoji.smileys_emotion.face_tongue.*
import org.kodein.emoji.smileys_emotion.face_unwell.*
import org.kodein.emoji.smileys_emotion.face_hand.*
import org.kodein.emoji.smileys_emotion.face_glasses.*
import org.kodein.emoji.smileys_emotion.face_hat.*
import org.kodein.emoji.smileys_emotion.face_costume.*
import org.kodein.emoji.smileys_emotion.monkey_face.*


internal fun EmojiFinder.addAllSmileysEmotion() {
    addAllFaceAffection()
    addAllFaceSleepy()
    addAllCatFace()
    addAllFaceNegative()
    addAllHeart()
    addAllFaceSmiling()
    addAllFaceConcerned()
    addAllEmotion()
    addAllFaceNeutralSkeptical()
    addAllFaceTongue()
    addAllFaceUnwell()
    addAllFaceHand()
    addAllFaceGlasses()
    addAllFaceHat()
    addAllFaceCostume()
    addAllMonkeyFace()
}

internal fun MutableList<Emoji>.addAllSmileysEmotion() {
    addAllFaceAffection()
    addAllFaceSleepy()
    addAllCatFace()
    addAllFaceNegative()
    addAllHeart()
    addAllFaceSmiling()
    addAllFaceConcerned()
    addAllEmotion()
    addAllFaceNeutralSkeptical()
    addAllFaceTongue()
    addAllFaceUnwell()
    addAllFaceHand()
    addAllFaceGlasses()
    addAllFaceHat()
    addAllFaceCostume()
    addAllMonkeyFace()
}

/**
 * All Emoji of the Smileys & Emotion group.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allSmileysEmotion(): List<Emoji> =
    ArrayList<Emoji>(168).apply { addAllSmileysEmotion() }

internal fun allSmileysEmotionSubgroups(): Map<String, () -> List<Emoji>> =
    mapOf(
        "face_affection" to { Emoji.allFaceAffection() },
        "face_sleepy" to { Emoji.allFaceSleepy() },
        "cat_face" to { Emoji.allCatFace() },
        "face_negative" to { Emoji.allFaceNegative() },
        "heart" to { Emoji.allHeart() },
        "face_smiling" to { Emoji.allFaceSmiling() },
        "face_concerned" to { Emoji.allFaceConcerned() },
        "emotion" to { Emoji.allEmotion() },
        "face_neutral_skeptical" to { Emoji.allFaceNeutralSkeptical() },
        "face_tongue" to { Emoji.allFaceTongue() },
        "face_unwell" to { Emoji.allFaceUnwell() },
        "face_hand" to { Emoji.allFaceHand() },
        "face_glasses" to { Emoji.allFaceGlasses() },
        "face_hat" to { Emoji.allFaceHat() },
        "face_costume" to { Emoji.allFaceCostume() },
        "monkey_face" to { Emoji.allMonkeyFace() },
    )
