package org.kodein.emoji.smileys_emotion.emotion

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllEmotion() {
    add(intArrayOf(0x1f4af), _HundredPoints)
    add(intArrayOf(0x1f4ab), _Dizzy)
    add(intArrayOf(0x1f4a5), _Collision)
    add(intArrayOf(0x1f4a8), _DashingAway)
    add(intArrayOf(0x1f4a6), _SweatDroplets)
    add(intArrayOf(0x1f4a4), _Zzz)
    add(intArrayOf(0x1f573, 0xfe0f), _Hole)
    add(intArrayOf(0x1f573), _Hole)
    add(intArrayOf(0x1f48b), _KissMark)
    add(intArrayOf(0x1f4ad), _ThoughtBalloon)
    add(intArrayOf(0x1f5ef, 0xfe0f), _RightAngerBubble)
    add(intArrayOf(0x1f5ef), _RightAngerBubble)
    add(intArrayOf(0x1f4ac), _SpeechBalloon)
    add(intArrayOf(0x1f5e8, 0xfe0f), _LeftSpeechBubble)
    add(intArrayOf(0x1f5e8), _LeftSpeechBubble)
    add(intArrayOf(0x1f4a2), _AngerSymbol)
    add(intArrayOf(0x1f441, 0xfe0f, 0x200d, 0x1f5e8, 0xfe0f), _EyeInSpeechBubble)
    add(intArrayOf(0x1f441, 0x200d, 0x1f5e8, 0xfe0f), _EyeInSpeechBubble)
    add(intArrayOf(0x1f441, 0xfe0f, 0x200d, 0x1f5e8), _EyeInSpeechBubble)
    add(intArrayOf(0x1f441, 0x200d, 0x1f5e8), _EyeInSpeechBubble)
}

internal fun MutableList<Emoji>.addAllEmotion() {
    add(_HundredPoints)
    add(_Dizzy)
    add(_Collision)
    add(_DashingAway)
    add(_SweatDroplets)
    add(_Zzz)
    add(_Hole)
    add(_KissMark)
    add(_ThoughtBalloon)
    add(_RightAngerBubble)
    add(_SpeechBalloon)
    add(_LeftSpeechBubble)
    add(_AngerSymbol)
    add(_EyeInSpeechBubble)
}

/**
 * All Emoji of the Smileys & Emotion: emotion subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allEmotion(): List<Emoji> =
    ArrayList<Emoji>(14).apply { addAllEmotion() }
