package org.kodein.emoji.smileys_emotion.face_unwell

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _HotFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🥵",
        description = "hot face",
        unicodeVersion = UnicodeVersion(11, 0),
        aliases = listOf("hot-face", "sweat-face"),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-unwell: hot face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.HotFace: Emoji get() = _HotFace

/**
 * Alias to emoji [HotFace] (Smileys & Emotion: face-unwell: hot face).
*/
public val Emoji.Companion.SweatFace: Emoji get() = _HotFace
