package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BlackMediumSquare: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "◼️",
        description = "black medium square",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("black-medium-square", "black-square-medium"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: geometric: black medium square.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BlackMediumSquare: Emoji get() = _BlackMediumSquare

/**
 * Alias to emoji [BlackMediumSquare] (Symbols: geometric: black medium square).
*/
public val Emoji.Companion.BlackSquareMedium: Emoji get() = _BlackMediumSquare
