package org.kodein.emoji.symbols.warning

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _NonPotableWater: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🚱",
        description = "non-potable water",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("non-potable-water", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: warning: non-potable water.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.NonPotableWater: Emoji get() = _NonPotableWater
