package org.kodein.emoji.activities.game

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlowerPlayingCards: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🎴",
        description = "flower playing cards",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("flower-playing-cards", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Activities: game: flower playing cards.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlowerPlayingCards: Emoji get() = _FlowerPlayingCards
