package org.kodein.emoji.activities.sport

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _IceSkate: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⛸️",
        description = "ice skate",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("ice-skate", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Activities: sport: ice skate.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.IceSkate: Emoji get() = _IceSkate
