package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagBrazil: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇧🇷",
        description = "flag: Brazil",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-brazil", "brazil-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.4285715f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Brazil.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagBrazil: Emoji get() = _FlagBrazil

/**
 * Alias to emoji [FlagBrazil] (Flags: country-flag: flag: Brazil).
*/
public val Emoji.Companion.BrazilFlag: Emoji get() = _FlagBrazil
