package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagVanuatu: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇻🇺",
        description = "flag: Vanuatu",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-vanuatu", "vanuatu-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.6666666f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Vanuatu.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagVanuatu: Emoji get() = _FlagVanuatu

/**
 * Alias to emoji [FlagVanuatu] (Flags: country-flag: flag: Vanuatu).
*/
public val Emoji.Companion.VanuatuFlag: Emoji get() = _FlagVanuatu
