package org.kodein.emoji.food_drink.drink

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllDrink() {
    add(intArrayOf(0x1f37c), _BabyBottle)
    add(intArrayOf(0x1f95b), _GlassOfMilk)
    add(intArrayOf(0x2615), _HotBeverage)
    add(intArrayOf(0x1fad6), _Teapot)
    add(intArrayOf(0x1f375), _TeacupWithoutHandle)
    add(intArrayOf(0x1f376), _Sake)
    add(intArrayOf(0x1f37e), _BottleWithPoppingCork)
    add(intArrayOf(0x1f377), _WineGlass)
    add(intArrayOf(0x1f378), _CocktailGlass)
    add(intArrayOf(0x1f379), _TropicalDrink)
    add(intArrayOf(0x1f37a), _BeerMug)
    add(intArrayOf(0x1f37b), _ClinkingBeerMugs)
    add(intArrayOf(0x1f942), _ClinkingGlasses)
    add(intArrayOf(0x1f943), _TumblerGlass)
    add(intArrayOf(0x1fad7), _PouringLiquid)
    add(intArrayOf(0x1f964), _CupWithStraw)
    add(intArrayOf(0x1f9cb), _BubbleTea)
    add(intArrayOf(0x1f9c3), _BeverageBox)
    add(intArrayOf(0x1f9c9), _Mate)
    add(intArrayOf(0x1f9ca), _Ice)
}

internal suspend fun SequenceScope<Emoji>.yieldAllDrink() {
    yield(_BabyBottle)
    yield(_GlassOfMilk)
    yield(_HotBeverage)
    yield(_Teapot)
    yield(_TeacupWithoutHandle)
    yield(_Sake)
    yield(_BottleWithPoppingCork)
    yield(_WineGlass)
    yield(_CocktailGlass)
    yield(_TropicalDrink)
    yield(_BeerMug)
    yield(_ClinkingBeerMugs)
    yield(_ClinkingGlasses)
    yield(_TumblerGlass)
    yield(_PouringLiquid)
    yield(_CupWithStraw)
    yield(_BubbleTea)
    yield(_BeverageBox)
    yield(_Mate)
    yield(_Ice)
}

internal val countDrink = 20

/**
 * All Emoji of the Food & Drink: drink subgroup.
*/
public fun Emoji.Companion.sequenceDrink(): Sequence<Emoji> =
    sequence { yieldAllDrink() }

/**
 * All Emoji of the Food & Drink: drink subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listDrink(): List<Emoji> =
    ArrayList<Emoji>(countDrink).also { list -> sequenceDrink().forEach { list.add(it) } }

@Deprecated("Renamed listDrink.", replaceWith = ReplaceWith("listDrink()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allDrink(): List<Emoji> =
    listDrink()
