package org.kodein.emoji.objects.book_paper

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PageFacingUp: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📄",
        description = "page facing up",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("page-facing-up", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: book-paper: page facing up.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PageFacingUp: Emoji get() = _PageFacingUp
