package org.kodein.emoji.objects.clothing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WomansBoot: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "👢",
        description = "woman’s boot",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("womans-boot", "boot"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: clothing: woman’s boot.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WomansBoot: Emoji get() = _WomansBoot

/**
 * Alias to emoji [WomansBoot] (Objects: clothing: woman’s boot).
*/
public val Emoji.Companion.Boot: Emoji get() = _WomansBoot
