package org.kodein.emoji.smileys_emotion.face_hand

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SalutingFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🫡",
        description = "saluting face",
        unicodeVersion = UnicodeVersion(14, 0),
        aliases = listOf("saluting-face", "salute"),
        emoticons = listOf("(・д・ゝ）"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-hand: saluting face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SalutingFace: Emoji get() = _SalutingFace

/**
 * Alias to emoji [SalutingFace] (Smileys & Emotion: face-hand: saluting face).
*/
public val Emoji.Companion.Salute: Emoji get() = _SalutingFace
