package org.kodein.emoji.smileys_emotion.face_neutral_skeptical

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SmirkingFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😏",
        description = "smirking face",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("smirking-face", "smirk"),
        emoticons = listOf(">~>"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-neutral-skeptical: smirking face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SmirkingFace: Emoji get() = _SmirkingFace

/**
 * Alias to emoji [SmirkingFace] (Smileys & Emotion: face-neutral-skeptical: smirking face).
*/
public val Emoji.Companion.Smirk: Emoji get() = _SmirkingFace
