package org.kodein.emoji.activities.game

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PuzzlePiece: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🧩",
        description = "puzzle piece",
        unicodeVersion = UnicodeVersion(11, 0),
        aliases = listOf("puzzle-piece", "jigsaw"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Activities: game: puzzle piece.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PuzzlePiece: Emoji get() = _PuzzlePiece

/**
 * Alias to emoji [PuzzlePiece] (Activities: game: puzzle piece).
*/
public val Emoji.Companion.Jigsaw: Emoji get() = _PuzzlePiece
