package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagAustralia: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇦🇺",
        description = "flag: Australia",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-australia", "australia-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Australia.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagAustralia: Emoji get() = _FlagAustralia

/**
 * Alias to emoji [FlagAustralia] (Flags: country-flag: flag: Australia).
*/
public val Emoji.Companion.AustraliaFlag: Emoji get() = _FlagAustralia
